/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.compliance;

import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class ReportsPanel
extends QDPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JEditorPane html;
    private RemoteInstrument m_instrument;
    private QDButton[] buttons;
    private URL url;
    private static final String reportListURL = "/fs/rptlist/ReportList.htm";

    public ReportsPanel(RemoteInstrument remoteInstrument) {
        this.m_instrument = remoteInstrument;
        this.init();
    }

    public void GoHome() {
        this.switchURL("http://" + this.m_instrument.getConnection().getName() + reportListURL);
    }

    public void switchURL(String string) {
        try {
            this.url = new URL(string);
            this.html.setPage(this.url);
            return;
        }
        catch (Exception exception) {
            System.err.println("Couldn't create URL: " + string);
            return;
        }
    }

    private void init() {
        JComponent jComponent;
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        Dimension dimension = new Dimension(650, 600);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
        try {
            this.html = new JEditorPane();
            this.html.setContentType("text/html");
            this.GoHome();
            this.html.setEditable(false);
            this.html.addHyperlinkListener(this.createHyperLinkListener());
        }
        catch (Exception exception) {
            System.err.println("Couldn't create help URL: ");
        }
        if (this.html != null) {
            jComponent = new JScrollPane(this.html);
            this.add((Component)jComponent, "Center");
        }
        jComponent = new QDPanel();
        this.buttons = new QDButton[2];
        this.buttons[0] = new QDButton("Go Home");
        this.buttons[1] = new QDButton("Refresh");
        for (int i = 0; i < this.buttons.length; ++i) {
            jComponent.add(this.buttons[i]);
            this.buttons[i].addActionListener(this);
        }
        this.add((Component)jComponent, "South");
    }

    public HyperlinkListener createHyperLinkListener() {
        return new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    ReportsPanel.this.html = (JEditorPane)hyperlinkEvent.getSource();
                    if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                        ((HTMLDocument)ReportsPanel.this.html.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)hyperlinkEvent);
                    } else {
                        try {
                            ReportsPanel.this.html.setPage(hyperlinkEvent.getURL());
                        }
                        catch (IOException iOException) {
                            System.out.println("IOE: " + iOException);
                        }
                    }
                }
            }
        };
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.buttons[0]) {
            this.GoHome();
        } else {
            String string = this.html.getPage().toString();
            if (string.equalsIgnoreCase("http://" + this.m_instrument.getConnection().getName() + reportListURL)) {
                this.switchURL("http://" + this.m_instrument.getConnection().getName() + "/");
            } else {
                this.GoHome();
            }
            this.switchURL(string);
        }
    }
}

